<?php
session_start();
require_once '../config/db.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    // Update last activity timestamp
    $_SESSION['last_activity'] = time();
    
    // Log heartbeat for debugging (optional)
    if (isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare("INSERT INTO system_logs (user_id, action, details) VALUES (?, 'heartbeat', ?)");
        $stmt->execute([$_SESSION['user_id'], 'Session heartbeat - ' . date('Y-m-d H:i:s')]);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Heartbeat received',
        'timestamp' => time(),
        'session_timeout' => 15 * 60 // 15 minutes in seconds
    ]);
    
} catch (Exception $e) {
    error_log("Heartbeat error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Internal server error'
    ]);
}
?> 